clear all

ALLERP=buildERPstruct([]);
CURRENTERP=0;

%% FILES & FOLDERS
Subjects = {'01', '02', '03', '04', '05', '06', '07', '08'};
Experimental_Folder = pwd;          % experiment folder (pwd = current folder)
GA_Folder = 'Grand_Avg';            % name of folder for grand avg & mean amp measures

%% EXPERIMENT PARAMETERS

N_Conditions = 3;                               % number of experimental conditions

Time_MA = [300 1100];                           % to-be-analyzed time window for mean amplitude
Bin_MA = [(N_Conditions*2+1):N_Conditions*3];	% bins for mean amplitude
Chan_MA = [2];                                  % channels for mean amplitude

Warnings = 'off';                               % warnings on or off?

Highpass_Filter = 1;                            % highpass filter applied?

%% PLOTTING PARAMETERS

Plot_Types = 2;                                     % figures to create
                                                    % 1 = present only difference waves
                                                    % 2 = present ipsi & contra plots as well

Bins_to_Plot_1 = (N_Conditions*2+1):N_Conditions*3;	% bins to plot - difference waves
Bins_to_Plot_2 = 1:(N_Conditions*2);                % bins to plot - ipsi & contra

Channels_to_Plot = [1:4];                           % numbers of channels that would be presented in the figure

%% Load final diff-waves files

GA_Path = [Experimental_Folder '\' GA_Folder '\'];

Set_Name = '';
if Highpass_Filter
    Set_Name = '_ERPs_diff.erp';
else
    Set_Name = '_ERPs_filt_diff.erp';
end;

Sub_Num = length(Subjects);

for i = 1:length(Subjects);
    
    Subject_Path = [Experimental_Folder '\' Subjects{i} '\'];
    
    % make sure the final diff-waves file exists
    Data_Name = [Subject_Path Subjects{i} Set_Name];
    if exist(Data_Name, 'file') <= 0
        fprintf('\nWhoops! %s doesn''t exist\nSkiping subject\n\n',Data_Name);
        Sub_Num = Sub_Num - 1;
    
    else % load final dataset
        fprintf('\n%s: Loading dataset\n',Subjects{i});
        ERP.erpname = [Subjects{i} Set_Name];
        ERP = pop_loaderp('filename', [Subjects{i} Set_Name], 'filepath', Subject_Path);
    
        % save ERP in ALLERP struct
        CURRENTERP = CURRENTERP+1;
        ALLERP(CURRENTERP) = ERP;
        
    end
    
    i=i+1;
    
end

%% Average across ERP sets

ERP = pop_gaverager(ALLERP, 'SEM', 'on', 'ERPindex', 1:Sub_Num);
ERP.erpname = 'Grand_avg';
ERP = pop_savemyerp(ERP, 'filename', [ERP.erpname '.erp'], 'filepath', GA_Path, 'warning', Warnings);
CURRENTERP = CURRENTERP+1;
ALLERP(CURRENTERP) = ERP;

%% Plot the averaged waves

pop_ploterps(ERP, Bins_to_Plot_1, Channels_to_Plot, 'LineWidth', 3, 'Style', 'Classic', 'YDir', 'reverse' );
if Plot_Types == 2
    pop_ploterps(ERP, Bins_to_Plot_2, Channels_to_Plot, 'LineWidth', 3, 'Style', 'Classic', 'YDir', 'reverse' );
end;

%% Measure mean amplitude

Values = pop_geterpvalues(ALLERP, Time_MA, Bin_MA, Chan_MA, 'Baseline', 'pre',...
	'Erpsets', 1:Sub_Num+1, 'FileFormat', 'wide', 'Filename',...
	[GA_Path 'Mean_Amp.txt'], 'Measure', 'meanbl', 'Resolution', 3);

fprintf('\nFinished!\n'); 
